<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section5
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                   
#  Last update : 10/10/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22'][.//ted:NOTICE/@*!='AWARD_CONTRACT' and .//ted:AWARD_CONTRACT]" mode="R600">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R600'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][.//ted:NOTICE/@*!='CONCESSION_AWARD_CONTRACT' and .//ted:AWARD_CONTRACT]" mode="R601">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R601'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22' or @FORM='F23'][.//ted:NOTICE/@*[matches(.,'AWARD')] and not(.//ted:AWARD_CONTRACT)]" mode="R608">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and missing AWARD_CONTRACT')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R608'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_CONCLUSION_CONTRACT" mode="R602">
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE[@*[matches(.,'CALL|QSU|ONLY|^CONTRACT|PRI')]]"/>
			<xsl:when test="not(number(replace(text(),'-','')) &gt; number(replace(ancestor::*[@FORM]//ted:DATE_DISPATCH_NOTICE/text(),'-','')))"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::ted:AWARD_CONTRACT/@ITEM,']//DATE_CONCLUSION_CONTRACT=',.,',DATE_DISPATCH_NOTICE=',ancestor::*[@FORM]//ted:DATE_DISPATCH_NOTICE)"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R602'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//ted:DIRECTIVE/@*!='2009/81/EC']//AWARDED_SUBCONTRACTING" mode="R604">
		<xsl:variable name="ele" select="concat('DIRECTIVE/@VALUE=', .//ted:DIRECTIVE/@*,' and AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/AWARDED_SUBCONTRACTING')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R604'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//ted:DIRECTIVE/@*!='2009/81/EC']//PCT_RANGE_SHARE_SUBCONTRACTING" mode="R605">
		<xsl:variable name="ele" select="concat('DIRECTIVE/@VALUE=', .//ted:DIRECTIVE/@*,' and AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/PCT_RANGE_SHARE_SUBCONTRACTING')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R605'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15'][.//ted:DIRECTIVE/@*='2009/81/EC']//PCT_RANGE_SHARE_SUBCONTRACTING/MAX[number()>30]" mode="R606">
		<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::AWARD_CONTRACT/@ITEM,']/PCT_RANGE_SHARE_SUBCONTRACTING/MAX (value=',number() ,'%)')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R606'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F13'][number(replace(.//ted:DATE_DECISION_JURY/text(),'-','')) &gt;= number(replace(.//ted:DATE_DISPATCH_NOTICE/text(),'-',''))]" mode="R607">
		<xsl:variable name="ele" select="concat('DATE_DECISION_JURY=',.//ted:DATE_DECISION_JURY/text(),', DATE_DISPATCH_NOTICE=',.//ted:DATE_DISPATCH_NOTICE/text())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R607'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM!='F20'][not(.//ted:LOT_DIVISION)]//ted:AWARD_CONTRACT[.//ted:LOT_NO]" mode="R603">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',@ITEM,']/LOT_NO: ')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R603'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM!='F20'][.//ted:LOT_DIVISION]//ted:AWARD_CONTRACT//ted:LOT_NO" mode="R609">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="count(ancestor::*[@FORM]//ted:OBJECT_CONTRACT)>1"/>
			<xsl:when test="ancestor::*[@FORM]//ted:OBJECT_DESCR[not(ted:LOT_NO)]"/>
			<xsl:when test="normalize-space() = ancestor::*[@FORM]//ted:OBJECT_DESCR/ted:LOT_NO/normalize-space()"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('AWARD_CONTRACT[',ancestor::*/@ITEM,']/LOT_NO')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R609'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM!='F20'][.//ted:LOT_DIVISION][not(.//ted:FRAMEWORK or .//ted:DPS or .//ted:PT_INNOVATION_PARTNERSHIP)][.//ted:AWARD_CONTRACT]" mode="R610">
		<xsl:variable name="nb1" select="count(.//ted:AWARD_CONTRACT[.//ted:CONTRACT_NO and .//ted:LOT_NO])"/>
		<xsl:variable name="nb2" select="count(distinct-values(.//ted:AWARD_CONTRACT[.//ted:CONTRACT_NO and .//ted:LOT_NO]/normalize-space(concat(.//ted:CONTRACT_NO,'-',.//ted:LOT_NO))))"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE/@*[not(matches(.,'AWARD'))]"/>
			<xsl:when test="$nb1 = $nb2"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'AWARD_CONTRACT[CONTRACT_NO and LOT_NO]'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R610'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
